#!/usr/bin/env python2

import Tkinter as tk
import ttk
import os


class CarTab(ttk.Frame):
    def __init__(self, parent, ip):
        ttk.Frame.__init__(self, parent)
        self.parent = parent
        self.ip = ip
        self.pack(fill='both')
        self._create_panel()

    def _create_panel(self):
        panel = ttk.Frame(self)
        panel.pack(fill='both')

        nb = ttk.Notebook(panel, width=390, height=390)
        # nb.enable_traversal()
        nb.pack(fill='both')
        self._create_terminal_tab(nb)

    def _create_terminal_tab(self, nb):
        tab = ttk.Frame(nb)

        wid = tab.winfo_id()
        # cmd = 'ssh root@' + self.ip
        os.system('urxvt -embed %d -g 50x20 &' % wid)

        nb.add(tab, text='terminal')


class MainApplication(ttk.Frame):
    def __init__(self, parent, title, *args, **kwargs):
        ttk.Frame.__init__(self, parent, *args, **kwargs)
        self.parent = parent
        self.master.title(title)
        self.ips = []
        self._create_panel()

    def _create_panel(self):
        panel = ttk.Frame(self, name='mainPanel')
        panel.pack(fill='both')

        nb = ttk.Notebook(panel, name='mainNotebook', width=400, height=400)
        # nb.enable_traversal()
        nb.pack(fill='both')
        self._create_add_tab(nb)

    def _create_add_tab(self, nb):
        tab = ttk.Frame(nb)

        ipEntry = ttk.Entry(tab)
        ipEntry.grid(row=0, column=0, padx=5, pady=5)

        confirmBtn = ttk.Button(tab, text='Confirm',
                                command=lambda:
                                self._add_tab(nb, ipEntry.get()))
        confirmBtn.grid(row=0, column=1, padx=5, pady=5)

        nb.add(tab, text='+')

    def _add_tab(self, nb, ip):
        self.ips += [ip]
        tab = CarTab(nb, ip)
        nb.add(tab, text=ip)


if __name__ == '__main__':
    root = tk.Tk()
    root.geometry('900x600')
    MainApplication(root, title='Bakusou Kyoudai').pack(side='top',
                                                        fill='both',
                                                        expand=True)
    root.mainloop()
